#cs
	SetupDownloaderConsole Configurator (alpha) provides a gui to configure your pcf-files.
    Copyright (C) 2010-2011  HSZemi

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#ce
#region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=frankico.ico
#AutoIt3Wrapper_outfile=..\Configurator (alpha).exe
#AutoIt3Wrapper_Res_Comment=SetupDownloaderConsole Configurator (alpha)
#AutoIt3Wrapper_Res_Description=SetupDownloaderConsole Configurator (alpha)
#AutoIt3Wrapper_Res_Fileversion=0.0.0.2
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright= HSZemi 2011
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_Field=CompanyName|HSZemi inc.
#AutoIt3Wrapper_Res_Field=Author|HSZemi
#endregion ;**** Directives created by AutoIt3Wrapper_GUI ****

#comments-start
	ToDo:
	Save Changes when checking boxes
	Allow to change downloaddir
#comments-end

#include <String.au3>
#include <File.au3>
#include <Constants.au3>
#include <Array.au3>
#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>

Opt("GUIOnEventMode", 1)

AutoItSetOption("TrayMenuMode", 1)
TraySetToolTip(StringLeft(@ScriptName, StringLen(@ScriptName) - 4) & " " & FileGetVersion(@ScriptName))

Dim $settingsfile = ".\ini\" & "SetupDownloaderConsole" & ".ini"
If Not FileExists($settingsfile) Then
	MsgBox(0, "Fehler", "Keine ini-Datei gefunden.")
	Sleep(5000)
	Exit
EndIf
Dim $return = 1

$download_dir = IniRead($settingsfile, "ENVIRONMENT", "downloaddir", ".\Download")

$whatsnewini = ".\ini\whatsnew.ini"

$pcfarray = _FileListToArray(".\ini", "*.pcf", 1)

Dim $programsarray[$pcfarray[0]][5]

$programsarray = _getprogramsarray($pcfarray)

;_ArrayDisplay($programsarray)
;Exit

$numberofprograms = $programsarray[0][0]
$gui_height = 110 + $numberofprograms * 30
#endregion

#region ### START Koda GUI section ### Form=
$Gui = GUICreate("Configurator", 434, $gui_height)
GUISetOnEvent($GUI_EVENT_CLOSE, "close")
$Label1 = GUICtrlCreateLabel("Downloadverzeichnis:", 16, 16, 108, 17)
$Input1 = GUICtrlCreateInput(IniRead($settingsfile, "ENVIRONMENT", "downloaddir", "n/A"), 128, 14, 257, 21)
$Button1 = GUICtrlCreateButton("...", 392, 12, 33, 24, $WS_GROUP)
GUICtrlSetState(-1, $GUI_DISABLE)
$Label2 = GUICtrlCreateLabel("letzte Ausfhrung: " & IniRead($whatsnewini, "GENERAL", "lastrun", "n/A"), 16, 45, 300, 17)

$Label5 = GUICtrlCreateLabel("Aktiviert", 18, 72, 48, 17)
$Label6 = GUICtrlCreateLabel("Name", 80, 72, 32, 17)
$Label7 = GUICtrlCreateLabel("Version", 210, 72, 39, 17)
$Label8 = GUICtrlCreateLabel("Autorun", 290, 72, 47, 17)
$Label9 = GUICtrlCreateLabel("pcf-Datei", 355, 72, 47, 17)

Dim $activeboxarray[$numberofprograms + 1]
Dim $namelabelarray[$numberofprograms + 1]
Dim $versionlabelarray[$numberofprograms + 1]
Dim $autorunboxarray[$numberofprograms + 1]
Dim $openbuttonarray[$numberofprograms + 1]

For $i = 1 To $numberofprograms
	$activeboxarray[$i] = GUICtrlCreateCheckbox("active", 32, 75 + $i * 30, 15, 17)
	GUICtrlSetState(-1, _getBannedGuiState($programsarray[$i][0]))
	GUICtrlSetState(-1, $GUI_DISABLE)
	$namelabelarray[$i] = GUICtrlCreateLabel($programsarray[$i][1], 80, 75 + $i * 30, 100, 17)
	$versionlabelarray[$i] = GUICtrlCreateLabel($programsarray[$i][2], 210, 75 + $i * 30, 80, 17)
	$autorunboxarray[$i] = GUICtrlCreateCheckbox("autorun", 300, 75 + $i * 30, 15, 17)
	GUICtrlSetState(-1, _getAutorunGuiState($programsarray[$i][3]))
	GUICtrlSetState(-1, $GUI_DISABLE)
	$openbuttonarray[$i] = GUICtrlCreateButton("ffnen", 350, 72 + $i * 30, 57, 25, $WS_GROUP)
	GUICtrlSetOnEvent(-1, "_openButtonClicked")
Next

GUISetState(@SW_SHOW)
#endregion ### END Koda GUI section ###

While 1
	Sleep(1000)
WEnd

Func _openButtonClicked()
	$id = @GUI_CtrlId
	For $i = 1 To $numberofprograms
		If $id = $openbuttonarray[$i] Then ShellExecute(".\ini\" & $programsarray[$i][4])
	Next
	Return
EndFunc   ;==>_openButtonClicked

Func _getAutorunGuiState($state_in)
	If $state_in == "yes" Then
		Return $GUI_CHECKED
	Else
		Return $GUI_UNCHECKED
	EndIf
EndFunc   ;==>_getAutorunGuiState

Func _getBannedGuiState($state_in)
	If $state_in == 0 Then
		Return $GUI_CHECKED
	Else
		Return $GUI_UNCHECKED
	EndIf
EndFunc   ;==>_getBannedGuiState



Func _getprogramsarray($pcfarray_in)
	If Not IsArray($pcfarray_in) Then
		MsgBox(0, "Error", "No pcf file found in ./ini. Please check and run again.")
		Exit
	EndIf

	Dim $activearray[$pcfarray_in[0] + 1]
	$activearray[0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$activearray[$i] = IniRead(".\ini\" & $pcfarray_in[$i], "variable", "banned", "0")
	Next

	Dim $namesarray[$pcfarray_in[0] + 1]
	$namesarray[0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$namesarray[$i] = IniRead(".\ini\" & $pcfarray_in[$i], "stable", "program_id", "error")
	Next


	Dim $versionarray[$pcfarray_in[0] + 1]
	$versionarray[0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$versionarray[$i] = IniRead(".\ini\" & $pcfarray_in[$i], "variable", "currentversion", "n/A")
	Next

	Dim $autorunarray[$pcfarray_in[0] + 1]
	$autorunarray[0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$autorunarray[$i] = IniRead(".\ini\" & $pcfarray_in[$i], "variable", "autorun", "no")
	Next

	Dim $programsarray[$pcfarray_in[0] + 1][5]
	$programsarray[0][0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$programsarray[$i][0] = $activearray[$i]
		$programsarray[$i][1] = $namesarray[$i]
		$programsarray[$i][2] = $versionarray[$i]
		$programsarray[$i][3] = $autorunarray[$i]
		$programsarray[$i][4] = $pcfarray_in[$i]
	Next
	Return $programsarray
EndFunc   ;==>_getprogramsarray

Func close()
	Exit
EndFunc   ;==>close
