#cs
	SetupDownloaderConsole helps you to keep your collection of software installers up to date.
    Copyright (C) 2010-2011  HSZemi

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#ce

#region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=frankico_sw.ico
#AutoIt3Wrapper_outfile=..\SetupDownloaderConsole.exe
#AutoIt3Wrapper_Change2CUI=y
#AutoIt3Wrapper_Res_Comment=SetupDownloaderConsole 5.2
#AutoIt3Wrapper_Res_Description=SetupDownloaderConsole 5.2
#AutoIt3Wrapper_Res_Fileversion=5.2.3.1
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright= HSZemi 2010-2011
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_Field=CompanyName|HSZemi inc.
#AutoIt3Wrapper_Res_Field=Author|HSZemi
#endregion ;**** Directives created by AutoIt3Wrapper_GUI ****

#NoTrayIcon
#include <String.au3>
#include <File.au3>
#include <Constants.au3>
#include <Array.au3>


#region init
;##################################
;# process command line arguments #
;##################################

;display version information and exit if "version" is command line argument
If StringInStr($CmdLineRaw, "version") Or StringInStr($CmdLineRaw, "?") Then
	displayVersionInformation()
	Exit
EndIf

If StringInStr($CmdLineRaw, "ascii") Then
	ascii()
	Exit
EndIf

;greet the user
ConsoleWrite("SetupDownloaderConsole " & StringLeft(FileGetVersion(@ScriptFullPath), 3) & @CRLF)
ConsoleWrite("(c) HSZemi 2011" & @CRLF)
ConsoleWrite("Build Version " & FileGetVersion(@ScriptFullPath) & @CRLF)
ConsoleWrite("Command line args: " & $CmdLineRaw & @CRLF)
ConsoleWrite(@CRLF)

;leave window opened if "noexit" is command line argument
Dim $NOEXIT = False
If StringInStr($CmdLineRaw, "noexit") Then $NOEXIT = True

;do not send mail if "nomail" is command line argument
Dim $SENDMAIL = True
If StringInStr($CmdLineRaw, "nomail") Then $SENDMAIL = False

Dim $newprogramscount = 0
If StringInStr($CmdLineRaw, "forceremind") Then $newprogramscount = 1

;set variables
;very important: ini-file where program's settings are stored
Dim $settingsfile = ".\ini\" & StringLeft(@ScriptName, StringLen(@ScriptName) - 4) & ".ini"
If Not FileExists($settingsfile) Then
	ConsoleWriteError("Inifile """ & $settingsfile & """ not found. Exiting...")
	Sleep(5000)
	Exit
EndIf

;very important: ini-file where email settings are stored
If $SENDMAIL Then
	Dim $blatini = ".\ini\blat.ini"
	If Not FileExists($blatini) Then
		ConsoleWriteError("Inifile """ & $blatini & """ not found." & @CRLF & "Will continue without email-support." & @CRLF & @CRLF)
		$SENDMAIL = False
	EndIf
EndIf

;read variables from ini
Dim $wgetdir = IniRead($settingsfile, "ENVIRONMENT", "wgetdir", ".\wget")
Dim $blatdir = FileGetShortName(IniRead($settingsfile, "ENVIRONMENT", "blatdir", ".\blat"), 1)
Dim $return = 1

$download_dir = IniRead($settingsfile, "ENVIRONMENT", "downloaddir", ".\Download")
If Not FileExists($download_dir) Then $return = DirCreate($download_dir)
If $return == 0 Then
	ConsoleWriteError("Error: Download directory doesn't exist and couldn't be created. Please check your settings in the inifile and try again.")
	Sleep(5000)
	Exit
Else
	ConsoleWrite("Download Directory is: " & $download_dir & @CRLF & @CRLF)
EndIf

$whatsnewini = FileGetShortName(".\ini\whatsnew.ini", 1)

#endregion init

IniWrite($whatsnewini, "GENERAL", "lastrun", @YEAR & "-" & @MON & "-" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC)

$pcfarray = _FileListToArray(".\ini", "*.pcf", 1)

Dim $programsarray = _getprogramsarray($pcfarray)

For $i = 1 To $pcfarray[0]
	$program_id = IniRead(".\ini\" & $pcfarray[$i], "stable", "program_id", "error")
	If IniRead(".\ini\" & $pcfarray[$i], "variable", "banned", "0") == 1 Then
		ConsoleWrite($program_id & " banned via pcf-file. Skipping..." & @CRLF & @CRLF)
	Else
		ConsoleWrite("Checking " & $program_id & "." & @CRLF)
;~ 		collect all data from the config file
		$versionpage = IniRead(".\ini\" & $pcfarray[$i], "stable", "versionpage", "error")
		$searchstring_before = IniRead(".\ini\" & $pcfarray[$i], "stable", "searchstring_before", "error")
		$searchstring_unique = IniRead(".\ini\" & $pcfarray[$i], "stable", "searchstring_unique", $searchstring_before)
		$linesafter = IniRead(".\ini\" & $pcfarray[$i], "stable", "linesafter", 0)
		$searchstring_after = IniRead(".\ini\" & $pcfarray[$i], "stable", "searchstring_after", "error")
		$downloadlink = IniRead(".\ini\" & $pcfarray[$i], "stable", "downloadlink", "error")
		$targetfilename = IniRead(".\ini\" & $pcfarray[$i], "stable", "targetfilename", "error")
		$currentversion = IniRead(".\ini\" & $pcfarray[$i], "variable", "currentversion", "n/A")
		$currentfilename = IniRead($pcfarray[$i], "variable", "currentfilename", "n/A")
;~ 		get the currently available version number, returns 0 if error occurs
		$programversion = _getversion($versionpage, $searchstring_unique, $searchstring_before, $searchstring_after, $linesafter)
		If $programversion <> 0 Then
			$downloadlink = StringReplace($downloadlink, "%version%", $programversion, 0, 0)
			$downloadlink = StringReplace($downloadlink, "%versionstripped%", StringReplace(StringReplace($programversion, "-", ""), ".", ""), 0, 0)

			$targetfilename = StringReplace($targetfilename, "%version%", $programversion, 0, 0)
			If FileExists($download_dir & "\" & $targetfilename) Then
				ConsoleWrite("File " & $targetfilename & " already exists." & @CRLF & "Skipping " & $program_id & "..." & @CRLF)
			ElseIf $downloadlink == 0 Then
				ConsoleWrite($program_id & " is configured as a non-download-software." & @CRLF)
				If $currentversion <> $programversion Then
					ConsoleWrite("New Version found: " & $programversion & @CRLF)
					$newprogramscount = $newprogramscount + 1
					IniWrite($whatsnewini, $program_id, "date", @YEAR & "-" & @MON & "-" & @MDAY & " " & @HOUR & ":" & @MIN)
					IniWrite($whatsnewini, $program_id, "oldversion", $currentversion)
					IniWrite($whatsnewini, $program_id, "newversion", $programversion)
					IniWrite($whatsnewini, $program_id, "dir", $versionpage)
					IniWrite($whatsnewini, $program_id, "filename", "")
				Else
					ConsoleWrite("No new Version available." & @CRLF)
				EndIf
			Else
				RunWait($wgetdir & "\wget.exe " & $downloadlink & " -P " & $download_dir & " -O " & $download_dir & "\" & $targetfilename & " -c")
				ConsoleWrite($program_id & " received." & @CRLF)
				$newprogramscount = $newprogramscount + 1
				IniWrite($whatsnewini, $program_id, "date", @YEAR & "-" & @MON & "-" & @MDAY & " " & @HOUR & ":" & @MIN)
				IniWrite($whatsnewini, $program_id, "oldversion", $currentversion)
				IniWrite($whatsnewini, $program_id, "newversion", $programversion)
				IniWrite($whatsnewini, $program_id, "dir", $download_dir)
				IniWrite($whatsnewini, $program_id, "filename", $targetfilename)
				; evtl autorun?
				If IniRead(".\ini\" & $pcfarray[$i], "variable", "autorun", "no") == "yes" Then
					ConsoleWrite("Starting " & $program_id & " installer." & @CRLF)
					Run($download_dir & "\" & $targetfilename & " " & IniRead(".\ini\" & $pcfarray[$i], "variable", "params", ""), $download_dir)
				EndIf
			EndIf
			IniWrite(".\ini\" & $pcfarray[$i], "variable", "currentversion", $programversion)
			IniWrite(".\ini\" & $pcfarray[$i], "variable", "currentfilename", $targetfilename)
			ConsoleWrite(@CRLF & @CRLF)
		Else
			ConsoleWriteError("No Version information for " & $program_id & " found. Please check corresponding pcf-file." & @CRLF & @CRLF)
			IniWrite($whatsnewini, $program_id, "date", @YEAR & "-" & @MON & "-" & @MDAY & " " & @HOUR & ":" & @MIN)
			If $currentversion <> "???" Then IniWrite($whatsnewini, $program_id, "oldversion", $currentversion)
			IniWrite($whatsnewini, $program_id, "newversion", "???")
			IniWrite($whatsnewini, $program_id, "dir", ".\ini\" & $pcfarray[$i])
			IniWrite($whatsnewini, $program_id, "filename", "")
		EndIf
	EndIf
Next

;finally notify via email if desired
If $SENDMAIL == True Then
	$whatsnewarray = IniReadSectionNames($whatsnewini)
	If IsArray($whatsnewarray) Then
		If $newprogramscount > 0 Then
			ConsoleWrite("Sending infomail..." & @CRLF & @CRLF)
			_sendInfoMail($whatsnewarray[0] - 1)
		EndIf
	EndIf
EndIf

ConsoleWrite(StringLeft(@ScriptName, StringLen(@ScriptName) - 4) & " - Console DONE." & @CRLF & @CRLF)

If $NOEXIT Then
	ConsoleWrite("Press CRTL+C to exit." & @CRLF & @CRLF)
	While 1
		Sleep(1000)
	WEnd
EndIf

Func _getversion($page_in, $stringunique_in, $stringbefore_in, $stringafter_in, $linesafter_in)
	RunWait($wgetdir & "\wget.exe " & $page_in & " -P " & @TempDir & " -O " & @TempDir & "\SDL_temp.txt" & " -c -q --no-check-certificate")
	$handle = FileOpen(@TempDir & "\SDL_temp.txt", 0)
	Do
		$line = FileReadLine($handle)
		If @error == -1 Then
			FileClose($handle)
			FileDelete(@TempDir & "\SDL_temp.txt")
			Return 0
		EndIf
	Until StringInStr($line, $stringunique_in)
	If $linesafter_in > 0 Then
		For $i = 1 To $linesafter_in
			$line = FileReadLine($handle)
		Next
	EndIf
	$version = _StringBetween($line, $stringbefore_in, $stringafter_in)
	If Not IsArray($version) Then
		FileClose($handle)
		FileDelete(@TempDir & "\SDL_temp.txt")
		Return 0
	Else
		$version = $version[0]
		FileClose($handle)
		FileDelete(@TempDir & "\SDL_temp.txt")
		$version = StringStripWS($version, 8)
		Return $version
	EndIf
EndFunc   ;==>_getversion

Func _getprogramsarray($pcfarray_in)
	If Not IsArray($pcfarray_in) Then
		ConsoleWriteError("Error: No pcf file found in ./ini. Please check and run again.")
		Sleep(5000)
		Exit
	EndIf
	Dim $namesarray[$pcfarray_in[0] + 1]
	$namesarray[0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$namesarray[$i] = IniRead(".\ini\" & $pcfarray_in[$i], "stable", "program_id", "error")
	Next
	Return $namesarray
EndFunc   ;==>_getprogramsarray

Func _exit()
	HotKeySet("q")
	Exit
EndFunc   ;==>_exit

Func _sendInfoMail($number_in)
	If Not FileExists($blatdir) Then
		ConsoleWriteError("blat dir not found.")
		Return
	EndIf
	$mailserver = IniRead($blatini, "SERVER", "server", "")
	$mailuser = IniRead($blatini, "SERVER", "user", "")
	$mailpass = IniRead($blatini, "SERVER", "pass", "")
	$mailfrom = IniRead($blatini, "MAIL", "from", "")
	$mailto = IniRead($blatini, "MAIL", "to", "")
	$mailsubject = IniRead($blatini, "MAIL", "subject", "")
	$mailsubject = StringReplace($mailsubject, "%number%", $number_in)
	RunWait($blatdir & "\blat.exe " & $whatsnewini & " -to " & $mailto & " -server " & $mailserver & " -u " & $mailuser & " -pw " & $mailpass & " -f """ & $mailfrom & """" & " -subject """ & $mailsubject & """")
EndFunc   ;==>_sendInfoMail

Func displayVersionInformation()
	ConsoleWrite(@CRLF)
	ConsoleWrite("SetupDownloaderConsole " & StringLeft(FileGetVersion(@ScriptFullPath), 3) & @CRLF)
	ConsoleWrite("(c) HSZemi 2011" & @CRLF)
	ConsoleWrite("Build Version " & FileGetVersion(@ScriptFullPath) & @CRLF)
	ConsoleWrite(@CRLF)
	ConsoleWrite("Command Line Parameters:" & @CRLF)
	ConsoleWrite("-version      | display this version information and quit" & @CRLF)
	ConsoleWrite("-noexit       | leave window opened after exit" & @CRLF)
	ConsoleWrite("-nomail       | do not send information email" & @CRLF)
	ConsoleWrite("-forceremind  | send information email if new software is available," & @CRLF)
	ConsoleWrite("                even if no new software has been found this time" & @CRLF)
	ConsoleWrite(@CRLF)
EndFunc   ;==>displayVersionInformation

Func ascii()
	ConsoleWrite("Conquer the castle!")
	ConsoleWrite(@CRLF)
	ConsoleWrite("  |" & @CRLF)
	ConsoleWrite("  |" & @CRLF)
	ConsoleWrite("  + \" & @CRLF)
	ConsoleWrite("  \\.G_.*=." & @CRLF)
	ConsoleWrite("   `( '/.\|" & @CRLF)
	ConsoleWrite("    .>' (_--." & @CRLF)
	ConsoleWrite(" _=/d   ,^\" & @CRLF)
	ConsoleWrite("~~ \)-'   '" & @CRLF)
	ConsoleWrite("   / |" & @CRLF)
	ConsoleWrite("  '  '" & @CRLF)
EndFunc   ;==>ascii
