#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=frankico.ico
#AutoIt3Wrapper_outfile=..\Configurator (alpha).exe
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Res_Comment=SetupDownloaderConsole Configurator (alpha)
#AutoIt3Wrapper_Res_Description=SetupDownloaderConsole Configurator (alpha)
#AutoIt3Wrapper_Res_Fileversion=0.0.1.9
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright= HSZemi 2011
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_Field=CompanyName|HSZemi inc.
#AutoIt3Wrapper_Res_Field=Author|HSZemi
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#cs
	SetupDownloaderConsole Configurator (alpha) provides a gui to configure your pcf-files.
	Copyright (C) 2010-2011  HSZemi

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
#ce

#comments-start
	ToDo:
	Save Changes when checking boxes
	Allow to change downloaddir
#comments-end

#include <String.au3>
#include <File.au3>
#include <Constants.au3>
#include <Array.au3>
#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <ListviewConstants.au3>


Opt("GUIOnEventMode", 1)

AutoItSetOption("TrayMenuMode", 1)
TraySetToolTip(StringLeft(@ScriptName, StringLen(@ScriptName) - 4) & " " & FileGetVersion(@ScriptName))

Dim $settingsfile = ".\ini\" & "SetupDownloaderConsole" & ".ini"
If Not FileExists($settingsfile) Then
	MsgBox(0, "Fehler", "Keine ini-Datei gefunden.")
	Sleep(5000)
	Exit
EndIf
Dim $return = 1

$download_dir = IniRead($settingsfile, "ENVIRONMENT", "downloaddir", ".\Download")

$whatsnewini = ".\ini\whatsnew.ini"

$pcfarray = _FileListToArray(".\ini", "*.pcf", 1)

Dim $programsarray[$pcfarray[0]][5]

$programsarray = _getprogramsarray($pcfarray)

;_ArrayDisplay($programsarray)
;Exit

$numberofprograms = $programsarray[0][0]
$maxheight = @DesktopHeight - 100
$gui_height = 110 + $numberofprograms * 19
If $gui_height > $maxheight Then $gui_height = $maxheight

#Region ### START Koda GUI section ### Form=
$Gui = GUICreate("Configurator", 400, $gui_height)
GUISetOnEvent($GUI_EVENT_CLOSE, "close")
$Label1 = GUICtrlCreateLabel("Download directory:", 16, 16, 108, 17)
$Input1 = GUICtrlCreateInput(IniRead($settingsfile, "ENVIRONMENT", "downloaddir", "n/A"), 128, 14, 220, 21)
GUICtrlSetState(-1, $GUI_DISABLE)
$Button1 = GUICtrlCreateButton("...", 354, 12, 30, 24, $WS_GROUP)
GUICtrlSetState(-1, $GUI_DISABLE)
$Label2 = GUICtrlCreateLabel("last run: " & IniRead($whatsnewini, "GENERAL", "lastrun", "n/A"), 16, 45, 300, 17)

$ListView = GUICtrlCreateListView("active|name                                   |version         |autorun", 14, 72, 370, $gui_height - 80)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_LV_ALTERNATE)



$totheright = 400



Dim $lvearray[$numberofprograms + 1]

For $i = 1 To $numberofprograms
	$lvearray[$i] = GUICtrlCreateListViewItem(_isActive($programsarray[$i][0]) & "|" & $programsarray[$i][1] & "|" & $programsarray[$i][2] & "|" & $programsarray[$i][3], $ListView)
	GUICtrlSetOnEvent(-1, "_openButtonClicked")
	GUICtrlSetBkColor(-1, 0xf3f3f3)
Next

$doubleClickTimer = TimerInit()

GUISetState(@SW_SHOW)
#EndRegion ### END Koda GUI section ###

While 1
	Sleep(1000)
WEnd

Func _openButtonClicked()
	If TimerDiff($doubleClickTimer) < 500 Then
		$id = @GUI_CtrlId
		For $i = 1 To $numberofprograms
			If $id = $lvearray[$i] Then ShellExecute(".\ini\" & $programsarray[$i][4])
		Next
	EndIf
	$doubleClickTimer = TimerInit()
	Return
EndFunc   ;==>_openButtonClicked

Func _isAutorun($state_in)
	If $state_in == "yes" Then
		Return $GUI_CHECKED
	Else
		Return $GUI_UNCHECKED
	EndIf
EndFunc   ;==>_isAutorun

Func _isActive($state_in)
	If $state_in == 0 Then
		Return "yes"
	Else
		Return "no"
	EndIf
EndFunc   ;==>_isActive


Func _getprogramsarray($pcfarray_in)
	If Not IsArray($pcfarray_in) Then
		MsgBox(0, "Error", "No pcf file found in ./ini. Please check and run again.")
		Exit
	EndIf

	Dim $activearray[$pcfarray_in[0] + 1]
	$activearray[0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$activearray[$i] = IniRead(".\ini\" & $pcfarray_in[$i], "variable", "banned", "0")
	Next

	Dim $namesarray[$pcfarray_in[0] + 1]
	$namesarray[0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$namesarray[$i] = IniRead(".\ini\" & $pcfarray_in[$i], "stable", "program_id", "error")
	Next


	Dim $versionarray[$pcfarray_in[0] + 1]
	$versionarray[0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$versionarray[$i] = IniRead(".\ini\" & $pcfarray_in[$i], "variable", "currentversion", "n/A")
	Next

	Dim $autorunarray[$pcfarray_in[0] + 1]
	$autorunarray[0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$autorunarray[$i] = IniRead(".\ini\" & $pcfarray_in[$i], "variable", "autorun", "no")
	Next

	Dim $programsarray[$pcfarray_in[0] + 1][5]
	$programsarray[0][0] = $pcfarray_in[0]
	For $i = 1 To $pcfarray_in[0]
		$programsarray[$i][0] = $activearray[$i]
		$programsarray[$i][1] = $namesarray[$i]
		$programsarray[$i][2] = $versionarray[$i]
		$programsarray[$i][3] = $autorunarray[$i]
		$programsarray[$i][4] = $pcfarray_in[$i]
	Next
	Return $programsarray
EndFunc   ;==>_getprogramsarray

Func close()
	Exit
EndFunc   ;==>close