#cs
	SetupDownloaderConsole WhatsNew displays changes and updates discovered by SetupDownloaderConsole.
	Copyright (C) 2010-2011  HSZemi
	
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
#ce
#region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=.\frankico.ico
#AutoIt3Wrapper_outfile=..\WhatsNew.exe
#AutoIt3Wrapper_Res_Comment=SetupDownloaderConsole WhatsNew checker
#AutoIt3Wrapper_Res_Description=SetupDownloaderConsole WhatsNew checker
#AutoIt3Wrapper_Res_Fileversion=1.1.0.1
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright= HSZemi 2010
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_Field=CompanyName|HSZemi inc.
#AutoIt3Wrapper_Res_Field=Author|HSZemi
#AutoIt3Wrapper_Run_Tidy=y
#endregion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include <Array.au3>
#include <String.au3>
#include <ButtonConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>

Opt("GUIOnEventMode", 1)

$whatsnewini = ".\ini\whatsnew.ini"

If Not FileExists($whatsnewini) Then
	MsgBox(48, "Error", "File " & $whatsnewini & " not found. Exiting...", 60)
	Exit
EndIf

$programsarray = IniReadSectionNames($whatsnewini)
;start from [2], as [0] contains number of elements and [1] = GENERAL

If $programsarray[0] < 2 Then
	MsgBox(64, "Zzz...", "Seems like there's nothing to do. You could go drink a coffee...", 60)
	Exit
EndIf

$gui_height = (2 * 8 + 25) * ($programsarray[0] - 1)


#region ### START Koda GUI section ###
$WhatsNew = GUICreate("WhatsNew", 465, $gui_height, -1, -1)
GUISetOnEvent($GUI_EVENT_CLOSE, "close")
For $i = 2 To $programsarray[0]
	_createEntriesFor($programsarray[$i], $i - 1)
Next
GUISetState(@SW_SHOW)
#endregion ### END Koda GUI section ###

While 1
	Sleep(100)
WEnd


Func _createEntriesFor($id_in, $count)
	$top = ($count - 1) * 41 + 12
	GUICtrlCreateLabel($id_in, 16, $top, 100, 17)
	GUICtrlCreateLabel(IniRead($whatsnewini, $id_in, "oldversion", "n/A"), 110, $top, 60, 17)
	GUICtrlSetColor(-1, 0xff0000)
	GUICtrlCreateLabel("=>", 180, $top, 16, 17)
	GUICtrlCreateLabel(IniRead($whatsnewini, $id_in, "newversion", "n/A"), 210, $top, 60, 17)
	GUICtrlSetColor(-1, 0x0a8a0a)
	GUICtrlCreateButton("  openDir    {" & $id_in & "}", 296, $top - 4, 57, 25, $BS_LEFT)
	GUICtrlSetOnEvent(-1, "openDirClicked")
	GUICtrlCreateButton("   Run    {" & $id_in & "}", 360, $top - 4, 44, 25, $BS_LEFT)
	GUICtrlSetOnEvent(-1, "runClicked")
	GUICtrlCreateButton("  X    {" & $id_in & "}", 430, $top - 4, 25, 25, $BS_LEFT)
	GUICtrlSetOnEvent(-1, "removeClicked")

	IniRead($whatsnewini, $id_in, "newversion", "n/A")
	IniRead($whatsnewini, $id_in, "dir", "n/A")
	IniRead($whatsnewini, $id_in, "filename", "n/A")
EndFunc   ;==>_createEntriesFor

Func openDirClicked()
	$progid = _StringBetween(GUICtrlRead(@GUI_CtrlId), "{", "}")
	$progid = $progid[0]
	If IniRead($whatsnewini, $progid, "filename", "") == "" Then
		ShellExecute(IniRead($whatsnewini, $progid, "dir", "n/A"))
	Else
		Run("explorer /select, " & IniRead($whatsnewini, $progid, "dir", "n/A") & "\" & IniRead($whatsnewini, $progid, "filename", ""))
	EndIf
EndFunc   ;==>openDirClicked

Func runClicked()
	$progid = _StringBetween(GUICtrlRead(@GUI_CtrlId), "{", "}")
	$progid = $progid[0]
	ShellExecute(IniRead($whatsnewini, $progid, "dir", "n/A") & "\" & IniRead($whatsnewini, $progid, "filename", "n/A"))
EndFunc   ;==>runClicked

Func removeClicked()
	$progid = _StringBetween(GUICtrlRead(@GUI_CtrlId), "{", "}")
	$progid = $progid[0]
	If MsgBox(36, "Removing...", "Are you sure you want to remove " & $progid & " from the listing?") == 6 Then
		IniDelete($whatsnewini, $progid)
		ShellExecute(@ScriptDir & "\" & @ScriptName)
		Exit
	EndIf
EndFunc   ;==>removeClicked

Func close()
	Exit
EndFunc   ;==>close