#region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=.\pcfupgrade.ico
#AutoIt3Wrapper_outfile=..\pcfUpgrade.exe
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Res_Comment=pcf Upgrade from Archive
#AutoIt3Wrapper_Res_Description=pcf Upgrade from Archive
#AutoIt3Wrapper_Res_Fileversion=0.1.0.3
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright= HSZemi 2011
#AutoIt3Wrapper_Res_Language=1031
#AutoIt3Wrapper_Res_Field=CompanyName|HSZemi inc.
#AutoIt3Wrapper_Res_Field=Author|HSZemi
#AutoIt3Wrapper_Run_Tidy=y
#endregion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include <File.au3>

;search for 7-zip, we'll use that later for extraction
$7zip = ".\7zip\7za.exe"
If Not FileExists($7zip) Then
	MsgBox(16, "Error", "7-zip is missing. Make sure 7za.exe is in the ""7zip""-subdirectory.")
	Exit
EndIf

;open upgrade package
$archivepath = FileOpenDialog("Select upgrade package", "", "Archives (*.7z;*.zip) | All Files (*.*)", 1)
FileChangeDir(@ScriptDir)
If $archivepath == "" Then Exit
If Not FileExists($archivepath) Then
	MsgBox(48, "Error", "Selected File does not exist.")
	Run(@ScriptFullPath)
	Exit
EndIf

;extract upgrade package to temporary directory
RunWait($7zip & " x " & $archivepath & " -o" & @TempDir & "\pcftemp")
If Not FileExists(@TempDir & "\pcftemp") Then
	MsgBox(48, "Error", "An error occured during extraction. Maybe the archive file is invalid. Please check your %TEMP% - folder for a directory called ""pcftemp"" and its content.")
	Exit
EndIf

;for every extracted file: check if filename exists in .\ini, if yes: run updatePcf with the two files
$pcfarrayold = _FileListToArray(".\ini", "*.pcf", 1)
If IsArray($pcfarrayold) Then
	For $i = 1 To $pcfarrayold[0]
		If FileExists(@TempDir & "\pcftemp\" & $pcfarrayold[$i]) Then
			updatePcf(@TempDir & "\pcftemp\" & $pcfarrayold[$i], ".\ini\" & $pcfarrayold[$i])
		EndIf
	Next
Else
	MsgBox(48, "That's strange", "Seems like there are no pcf-files in your .\ini - subdirectory.")
	Exit
EndIf

;clean up temp dir
Sleep(500)
DirRemove(@TempDir & "\pcftemp\")

;finish
MsgBox(0, "Done", "Operation finished successfully.")


;write values from file in Temp to file in .\ini, delete searchstring_unique and linesafter if they are obsolete
Func updatePcf($new, $old)
	$section = IniReadSection($new, "stable")
	If IsArray($section) Then
		IniWriteSection($old, "stable", $section)
	EndIf
	If IniRead($new, "stable", "searchstring_unique", "sdc_default") == "sdc_default" And IniRead($old, "stable", "searchstring_unique", "sdc_default") <> "sdc_default" Then
		IniDelete($new, "stable", "searchstring_unique")
	EndIf
	If IniRead($new, "stable", "linesafter", "sdc_default") == "sdc_default" And IniRead($old, "stable", "linesafter", "sdc_default") <> "sdc_default" Then
		IniDelete($new, "stable", "linesafter")
	EndIf
EndFunc   ;==>updatePcf